/*
 * Decompiled with CFR 0.152.
 */
package jclass.chart;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import jclass.bwt.JCComponent;
import jclass.chart.Changeable;
import jclass.chart.DerivedInt;
import jclass.chart.JCChart;
import jclass.chart.JCChartUtil;
import jclass.chart.PropertyFrame;

public abstract class ChartCanvas
extends JCComponent
implements Changeable {
    boolean isShowing = true;
    boolean showBorder = true;
    boolean changed = true;
    boolean needsRepaint = true;
    JCChart chart;
    DerivedInt top = new DerivedInt(0, true);
    DerivedInt left = new DerivedInt(0, true);
    DerivedInt cc_width = new DerivedInt(0, true);
    DerivedInt cc_height = new DerivedInt(0, true);
    Dimension ps = new Dimension(0, 0);
    boolean cached = false;
    int cache_highlight;
    int cache_shadow;
    int cache_shadow_type;
    private boolean dimIsDefaultChangedToTrue = false;
    private PropertyFrame myPropertyFrame;
    static boolean inUpdate;

    ChartCanvas() {
        this.shadow_type = 0;
        this.shadow = 2;
        this.highlight = 0;
        this.enableEvents(16L);
        this.enableEvents(32L);
        this.setInsets(new Insets(2, 2, 2, 2));
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.chart.processMouseEvent(mouseEvent);
            return;
        }
        super.processMouseEvent(mouseEvent);
    }

    private void displayPropertyPage(int n, int n2) {
        this.setCursor(3);
        if (this.myPropertyFrame == null) {
            this.myPropertyFrame = new PropertyFrame(this.getClass().getName());
            this.myPropertyFrame.setValue(this);
        } else {
            this.myPropertyFrame.show();
        }
        this.myPropertyFrame.move(n, n2);
        this.setCursor(0);
    }

    public void paintComponent(Graphics graphics) {
        Rectangle rectangle = this.getDrawingArea();
        graphics.translate(rectangle.x, rectangle.y);
    }

    public boolean getIsShowing() {
        return this.isShowing;
    }

    public synchronized void setIsShowing(boolean bl) {
        this.isShowing = bl;
        if (!this.showBorder) {
            if (bl) {
                if (this.cached) {
                    this.shadow_type = this.cache_shadow_type;
                    this.shadow = this.cache_shadow;
                    this.highlight = this.cache_highlight;
                }
            } else {
                this.cache_shadow_type = this.shadow_type;
                this.cache_shadow = this.shadow;
                this.cache_highlight = this.highlight;
                this.shadow_type = 0;
                this.shadow = 0;
                this.highlight = 0;
                this.cached = true;
            }
        }
        this.setChanged(true);
    }

    public synchronized void setBorderType(int n) {
        if (this.shadow_type == n) {
            return;
        }
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.shadow_type = n;
                this.setChanged(true);
                return;
            }
        }
        throw new IllegalArgumentException("Invalid BorderType in ChartCanvas");
    }

    public int getBorderType() {
        return this.shadow_type;
    }

    public synchronized void setBorderWidth(int n) {
        if (n == this.shadow) {
            return;
        }
        if (n < 0) {
            throw new IllegalArgumentException("BorderWidth must be positive");
        }
        this.shadow = n;
        this.setChanged(true);
    }

    public int getBorderWidth() {
        return this.shadow;
    }

    public Dimension preferredSize() {
        this.ps = super.preferredSize();
        if (!this.cc_width.isDefault) {
            this.ps.width = this.cc_width.value;
        }
        if (!this.cc_height.isDefault) {
            this.ps.height = this.cc_height.value;
        }
        if (!this.isShowing) {
            this.ps.height = 0;
            this.ps.width = 0;
        }
        return this.ps;
    }

    public Dimension minimumSize() {
        return this.preferredSize();
    }

    public synchronized void setTop(int n) {
        if (this.top.value == n) {
            return;
        }
        this.top.value = n;
        this.top.isDefault = false;
        this.setChanged(true);
    }

    public int getTop() {
        if (this.top.isDefault) {
            this.top.value = this.location().y;
        }
        return this.top.value;
    }

    public synchronized void setTopIsDefault(boolean bl) {
        if (this.top.isDefault == bl) {
            return;
        }
        this.top.isDefault = bl;
        this.dimIsDefaultChangedToTrue = bl;
        this.setChanged(true);
    }

    public boolean getTopIsDefault() {
        return this.top.isDefault;
    }

    public synchronized void setLeft(int n) {
        if (this.left.value == n) {
            return;
        }
        this.left.value = n;
        this.left.isDefault = false;
        this.setChanged(true);
    }

    public int getLeft() {
        if (this.left.isDefault) {
            this.left.value = this.location().x;
        }
        return this.left.value;
    }

    public synchronized void setLeftIsDefault(boolean bl) {
        if (this.left.isDefault == bl) {
            return;
        }
        this.left.isDefault = bl;
        this.dimIsDefaultChangedToTrue = bl;
        this.setChanged(true);
    }

    public boolean getLeftIsDefault() {
        return this.left.isDefault;
    }

    public synchronized void setWidth(int n) {
        if (this.cc_width.value == n) {
            return;
        }
        this.cc_width.value = n;
        this.cc_width.isDefault = false;
        this.setChanged(true);
    }

    public int getWidth() {
        if (this.cc_width.isDefault) {
            this.cc_width.value = this.size().width;
        }
        return this.cc_width.value;
    }

    public synchronized void setWidthIsDefault(boolean bl) {
        if (this.cc_width.isDefault == bl) {
            return;
        }
        this.cc_width.isDefault = bl;
        this.dimIsDefaultChangedToTrue = bl;
        this.setChanged(true);
    }

    public boolean getWidthIsDefault() {
        return this.cc_width.isDefault;
    }

    public synchronized void setHeight(int n) {
        if (this.cc_height.value == n) {
            return;
        }
        this.cc_height.value = n;
        this.cc_height.isDefault = false;
        this.setChanged(true);
    }

    public int getHeight() {
        if (this.cc_height.isDefault) {
            this.cc_height.value = this.size().height;
        }
        return this.cc_height.value;
    }

    public synchronized void setHeightIsDefault(boolean bl) {
        if (this.cc_height.isDefault == bl) {
            return;
        }
        this.cc_height.isDefault = bl;
        this.dimIsDefaultChangedToTrue = bl;
        this.setChanged(true);
    }

    public boolean getHeightIsDefault() {
        return this.cc_height.isDefault;
    }

    public boolean getChanged() {
        return this.changed;
    }

    public final boolean isChanged() {
        return this.getChanged();
    }

    public void setChanged(boolean bl) {
        if (bl == this.changed) {
            return;
        }
        this.changed = bl;
        Container container = this.getParent();
        if (container == null || container.getPeer() == null) {
            return;
        }
        if (bl) {
            if (container instanceof JCChart && ((JCChart)container).getIsBatched()) {
                this.invalidate();
                return;
            }
            this.updateParent();
        }
    }

    public void setChanged(boolean bl, boolean bl2) {
        if (bl2) {
            this.setChanged(bl);
            return;
        }
        this.changed = bl;
    }

    public synchronized void repaint() {
        if (this.needsRepaint) {
            super.repaint(0, 0, this.size().width, this.size().height);
        }
        this.needsRepaint = false;
    }

    public void updateParent() {
        if (inUpdate) {
            System.out.println("Warning - re-entrance!");
            JCChartUtil.trace();
        }
        inUpdate = true;
        if (this.getParent() != null && this.getParent().getPeer() != null) {
            this.invalidate();
            this.getParent().invalidate();
            this.getParent().validate();
            if (this.getParent().getPeer() != null) {
                this.repaint();
            }
        }
        inUpdate = false;
    }

    public int preferredWidth() {
        return 0;
    }

    public int preferredHeight() {
        return 0;
    }

    protected void getParameters() {
        super.getParameters();
    }

    void setParentChart(JCChart jCChart) {
        this.chart = jCChart;
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        if (!this.top.isDefault) {
            n2 = this.top.value;
        }
        if (!this.left.isDefault) {
            n = this.left.value;
        }
        if (!this.cc_width.isDefault) {
            n3 = this.cc_width.value;
        }
        if (!this.cc_height.isDefault) {
            n4 = this.cc_height.value;
        }
        super.reshape(n, n2, n3, n4);
    }

    public void recalc() {
    }

    public boolean sizeChanged() {
        if (this.dimIsDefaultChangedToTrue) {
            this.dimIsDefaultChangedToTrue = false;
            return true;
        }
        return this.getLeft() != this.location().x || this.getTop() != this.location().y || this.getWidth() != this.size().width || this.getHeight() != this.size().height;
    }

    public synchronized void setBackground(Color color) {
        super.setBackground(color);
        this.setChanged(true);
    }

    public synchronized void setForeground(Color color) {
        super.setForeground(color);
        this.setChanged(true);
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        this.setChanged(true);
    }
}

